/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class QTRLECodec
extends BaseCodec {
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new FormatException("QTRLE compression not supported.");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        byte[] b = new byte[(int)(in.length() - in.getFilePointer())];
        in.read(b);
        return this.decompress(b, options);
    }

    public byte[] decompress(byte[] data, CodecOptions options) throws FormatException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        int numLines = options.height;
        if (data.length < 8) {
            return options.previousImage;
        }
        int bpp = options.bitsPerSample / 8;
        int line = options.width * bpp;
        try {
            ByteArrayHandle s = new ByteArrayHandle(data);
            s.skipBytes(4);
            short header = s.readShort();
            int off = 0;
            int start = 0;
            byte[] output = new byte[options.height * line];
            if ((header & 8) == 8) {
                int i;
                start = s.readShort();
                s.skipBytes(2);
                numLines = s.readShort();
                s.skipBytes(2);
                if (options.previousImage != null) {
                    for (i = 0; i < start; ++i) {
                        System.arraycopy(options.previousImage, off, output, off, line);
                        off += line;
                    }
                }
                if (options.previousImage != null) {
                    off = line * (start + numLines);
                    for (i = start + numLines; i < options.height; ++i) {
                        System.arraycopy(options.previousImage, off, output, off, line);
                        off += line;
                    }
                }
            } else {
                throw new FormatException("Unsupported header : " + header);
            }
            int skip = 0;
            byte rle = 0;
            int rowPointer = start * line;
            for (int i = 0; i < numLines; ++i) {
                block29: {
                    skip = s.readUnsignedByte();
                    if (skip < 0) {
                        skip += 256;
                    }
                    if (options.previousImage != null) {
                        try {
                            System.arraycopy(options.previousImage, rowPointer, output, rowPointer, (skip - 1) * bpp);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    }
                    off = rowPointer + (skip - 1) * bpp;
                    do {
                        if ((rle = (byte)(s.readUnsignedByte() & 0xFF)) == 0) {
                            skip = s.readUnsignedByte();
                            if (options.previousImage != null) {
                                try {
                                    System.arraycopy(options.previousImage, off, output, off, (skip - 1) * bpp);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    // empty catch block
                                }
                            }
                            off += (skip - 1) * bpp;
                            continue;
                        }
                        if (rle == -1) {
                            if (off < rowPointer + line && options.previousImage != null) {
                                System.arraycopy(options.previousImage, off, output, off, rowPointer + line - off);
                            }
                            break block29;
                        }
                        if (rle < -1) {
                            for (int j = 0; j < -1 * rle && off < output.length; off += bpp, ++j) {
                                System.arraycopy(data, (int)s.getFilePointer(), output, off, bpp);
                            }
                            s.skipBytes(bpp);
                            continue;
                        }
                        int len = rle * bpp;
                        if (output.length - off < len) {
                            len = output.length - off;
                        }
                        if (s.length() - s.getFilePointer() < (long)len) {
                            len = (int)(s.length() - s.getFilePointer());
                        }
                        if (len < 0) {
                            len = 0;
                        }
                        if (off > output.length) {
                            off = output.length;
                        }
                        s.read(output, off, len);
                        off += len;
                    } while (s.getFilePointer() < s.length());
                    return output;
                }
                rowPointer += line;
            }
            return output;
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
    }
}

