/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.NIOFileHandle;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexReader
extends FormatReader {
    public static final int FLEX = 65200;
    public static final String FLEX_SUFFIX = "flex";
    public static final String MEA_SUFFIX = "mea";
    public static final String RES_SUFFIX = "res";
    public static final String[] MEASUREMENT_SUFFIXES = new String[]{"mea", "res"};
    public static final String[] SUFFIXES = new String[]{"flex", "mea", "res"};
    public static final String SCREENING = "Screening";
    public static final String ARCHIVE = "Archive";
    private static HashMap<String, String[]> serverMap = new HashMap();
    protected double[][][] factors;
    private int binX;
    private int binY;
    private int plateCount;
    private int wellCount;
    private int fieldCount;
    private int wellRows;
    private int wellColumns;
    private Vector<String> channelNames;
    private Vector<Double> xPositions;
    private Vector<Double> yPositions;
    private Vector<Double> xSizes;
    private Vector<Double> ySizes;
    private Vector<String> cameraIDs;
    private Vector<String> objectiveIDs;
    private Vector<String> lightSourceIDs;
    private HashMap<String, Vector<String>> lightSourceCombinationIDs;
    private Vector<String> cameraRefs;
    private Vector<String> binnings;
    private Vector<String> objectiveRefs;
    private Vector<String> lightSourceCombinationRefs;
    private Vector<String> filterSets;
    private HashMap<String, FilterGroup> filterSetMap;
    private Vector<String> measurementFiles;
    private String plateName;
    private String plateBarcode;
    private int nRows = 0;
    private int nCols = 0;
    private RandomAccessInputStream firstStream;
    private String plateAcqStartTime;
    private String[][] flexFiles;
    private IFDList[][] ifds;
    private long[][][] offsets;
    private int[][] wellNumber;

    public FlexReader() {
        super("Evotec Flex", SUFFIXES);
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.hasCompanionFiles = true;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        if (!FlexReader.checkSuffix(id, FLEX_SUFFIX)) {
            return false;
        }
        return serverMap.size() == 0 || !this.isGroupFiles();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        int[] lengths;
        int[] pos;
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.addAll(this.measurementFiles);
        if (!noPixels && this.fieldCount > 0 && this.wellCount > 0 && this.plateCount > 0 && (pos = FormatTools.rasterToPosition(lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount}, this.getSeries()))[1] >= 0 && pos[1] < this.wellNumber.length) {
            int col;
            int row = this.wellCount == 1 ? 0 : this.wellNumber[pos[1]][0];
            int n = col = this.wellCount == 1 ? 0 : this.wellNumber[pos[1]][1];
            if (row < this.flexFiles.length && col < this.flexFiles[row].length) {
                files.add(this.flexFiles[row][col]);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        int[] lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount};
        int[] pos = FormatTools.rasterToPosition(lengths, this.getSeries());
        int wellRow = this.wellNumber[pos[1]][0];
        int wellCol = this.wellNumber[pos[1]][1];
        if (this.wellCount == 1) {
            wellRow = 0;
            wellCol = 0;
        }
        IFD ifd = (IFD)this.ifds[wellRow][wellCol].get(0);
        try {
            return (int)ifd.getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        int[] lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount};
        int[] pos = FormatTools.rasterToPosition(lengths, this.getSeries());
        int wellRow = this.wellNumber[pos[1]][0];
        int wellCol = this.wellNumber[pos[1]][1];
        if (this.wellCount == 1) {
            wellRow = 0;
            wellCol = 0;
        }
        IFD ifd = (IFD)this.ifds[wellRow][wellCol].get(0);
        try {
            return (int)ifd.getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount};
        int[] pos = FormatTools.rasterToPosition(lengths, this.getSeries());
        int wellRow = this.wellNumber[pos[1]][0];
        int wellCol = this.wellNumber[pos[1]][1];
        if (this.wellCount == 1) {
            wellRow = 0;
            wellCol = 0;
        }
        int imageNumber = this.offsets[wellRow][wellCol] == null ? this.getImageCount() * pos[0] + no : 0;
        IFD ifd = this.offsets[wellRow][wellCol] == null ? (IFD)this.ifds[wellRow][wellCol].get(imageNumber) : (IFD)this.ifds[0][0].get(0);
        RandomAccessInputStream s = wellRow == 0 && wellCol == 0 ? this.firstStream : new RandomAccessInputStream(new NIOFileHandle(this.flexFiles[wellRow][wellCol], "r"));
        int nBytes = ifd.getBitsPerSample()[0] / 8;
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int planeSize = this.getSizeX() * this.getSizeY() * this.getRGBChannelCount() * nBytes;
        double factor = 1.0;
        if (ifd.getCompression() != TiffCompression.UNCOMPRESSED || nBytes != bpp || this.offsets[wellRow][wellCol] == null) {
            TiffParser tp = new TiffParser(s);
            tp.getSamples(ifd, buf, x, y, w, h);
            factor = this.factors[wellRow][wellCol][imageNumber];
        } else {
            int index = this.getImageCount() * pos[0] + no;
            long offset = index == this.offsets[wellRow][wellCol].length - 1 ? s.length() : this.offsets[wellRow][wellCol][index + 1];
            s.seek(offset - (long)planeSize);
            this.readPlane(s, x, y, w, h, buf);
            factor = this.factors[0][0][index];
        }
        if (wellRow != 0 || wellCol != 0) {
            s.close();
        }
        int num = buf.length / bpp;
        if (factor != 1.0 || nBytes != bpp) {
            for (int i = num - 1; i >= 0; --i) {
                int q;
                int n = q = nBytes == 1 ? buf[i] & 0xFF : DataTools.bytesToInt(buf, i * bpp, bpp, this.isLittleEndian());
                if (q == 0) continue;
                q = (int)((double)q * factor);
                DataTools.unpackBytes(q, buf, i * bpp, bpp, this.isLittleEndian());
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.factors = null;
            this.binY = 0;
            this.binX = 0;
            this.fieldCount = 0;
            this.wellCount = 0;
            this.plateCount = 0;
            this.channelNames = null;
            this.measurementFiles = null;
            this.ySizes = null;
            this.xSizes = null;
            this.lightSourceIDs = null;
            this.objectiveIDs = null;
            this.cameraIDs = null;
            this.lightSourceCombinationIDs = null;
            this.lightSourceCombinationRefs = null;
            this.binnings = null;
            this.objectiveRefs = null;
            this.cameraRefs = null;
            this.wellColumns = 0;
            this.wellRows = 0;
            this.yPositions = null;
            this.xPositions = null;
            this.filterSets = null;
            this.filterSetMap = null;
            this.plateBarcode = null;
            this.plateName = null;
            this.nCols = 0;
            this.nRows = 0;
            this.flexFiles = null;
            this.ifds = null;
            this.offsets = null;
            this.wellNumber = null;
            if (this.firstStream != null) {
                this.firstStream.close();
            }
            this.firstStream = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.measurementFiles = new Vector();
        if (FlexReader.checkSuffix(id, FLEX_SUFFIX)) {
            this.initFlexFile(id);
        } else if (FlexReader.checkSuffix(id, RES_SUFFIX)) {
            this.initResFile(id);
        } else {
            this.initMeaFile(id);
        }
    }

    private void initResFile(String id) throws FormatException, IOException {
        String[] list;
        LOGGER.debug("initResFile({})", (Object)id);
        this.parseResFile(id);
        Location thisFile = new Location(id).getAbsoluteFile();
        Location parent = thisFile.getParentFile();
        LOGGER.debug("  Looking for an .mea file in {}", (Object)parent.getAbsolutePath());
        for (String file2 : list = parent.list()) {
            if (!FlexReader.checkSuffix(file2, MEA_SUFFIX)) continue;
            String mea = new Location(parent, file2).getAbsolutePath();
            LOGGER.debug("  Found .mea file {}", (Object)mea);
            this.initMeaFile(mea);
            if (!this.measurementFiles.contains(thisFile.getAbsolutePath())) {
                this.measurementFiles.add(thisFile.getAbsolutePath());
            }
            return;
        }
        throw new FormatException("Could not find an .mea file.");
    }

    private void initMeaFile(String id) throws FormatException, IOException {
        String[] files;
        LOGGER.debug("initMeaFile({})", (Object)id);
        Location file2 = new Location(id).getAbsoluteFile();
        if (!this.measurementFiles.contains(file2.getAbsolutePath())) {
            this.measurementFiles.add(file2.getAbsolutePath());
        }
        MeaHandler handler = new MeaHandler();
        LOGGER.info("Reading contents of .mea file");
        LOGGER.info("Parsing XML from .mea file");
        RandomAccessInputStream s = new RandomAccessInputStream(id);
        XMLTools.parseXML(s, (DefaultHandler)handler);
        s.close();
        Vector<String> flex = handler.getFlexFiles();
        if (flex.size() == 0) {
            LOGGER.debug("Could not build .flex list from .mea.");
            LOGGER.info("Building list of valid .flex files");
            files = this.findFiles(file2);
            if (files != null) {
                for (String f : files) {
                    if (!FlexReader.checkSuffix(f, FLEX_SUFFIX)) continue;
                    flex.add(f);
                }
            }
            if (flex.size() == 0) {
                throw new FormatException(".flex files were not found. Did you forget to specify the server names?");
            }
        }
        LOGGER.info("Looking for corresponding .res file");
        files = this.findFiles(file2, new String[]{RES_SUFFIX});
        if (files != null) {
            for (String f : files) {
                if (!this.measurementFiles.contains(f)) {
                    this.measurementFiles.add(f);
                }
                this.parseResFile(f);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        this.groupFiles(flex.toArray(new String[flex.size()]), store);
        this.populateMetadataStore(store);
    }

    private void initFlexFile(String id) throws FormatException, IOException {
        String[] stringArray;
        LOGGER.debug("initFlexFile({})", (Object)id);
        boolean doGrouping = true;
        Location currentFile = new Location(id).getAbsoluteFile();
        LOGGER.info("Storing well indices");
        try {
            String name = currentFile.getName();
            int[] well = this.getWell(name);
            if (well[0] > this.nRows) {
                this.nRows = well[0];
            }
            if (well[1] > this.nCols) {
                this.nCols = well[1];
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Could not parse well indices", e);
            doGrouping = false;
        }
        LOGGER.info("Looking for other .flex files");
        if (!this.isGroupFiles()) {
            doGrouping = false;
        }
        if (this.isGroupFiles()) {
            LOGGER.debug("Attempting to find files in the same dataset.");
            try {
                this.findFiles(currentFile);
            }
            catch (NullPointerException e) {
                LOGGER.debug("", e);
            }
            catch (IOException e) {
                LOGGER.debug("", e);
            }
            if (this.measurementFiles.size() == 0) {
                LOGGER.warn("Measurement files not found.");
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        LOGGER.info("Making sure that all .flex files are valid");
        Vector<String> flex = new Vector<String>();
        if (doGrouping) {
            String[] files;
            Location dir = currentFile.getParentFile();
            for (String file2 : files = dir.list(true)) {
                LOGGER.debug("Checking if {} belongs in the same dataset.", (Object)file2);
                if (!file2.endsWith(".flex") || file2.length() != 14) continue;
                flex.add(new Location(dir, file2).getAbsolutePath());
                LOGGER.debug("Added {} to dataset.", flex.get(flex.size() - 1));
            }
        }
        if (doGrouping) {
            stringArray = flex.toArray(new String[flex.size()]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = currentFile.getAbsolutePath();
        }
        String[] files = stringArray;
        if (files.length == 0) {
            files = new String[]{currentFile.getAbsolutePath()};
        }
        LOGGER.debug("Determined that {} .flex files belong together.", files.length);
        this.groupFiles(files, store);
        this.populateMetadataStore(store);
    }

    private void populateMetadataStore(MetadataStore store) throws FormatException {
        LOGGER.info("Populating MetadataStore");
        MetadataTools.populatePixels(store, this, true);
        Location currentFile = new Location(this.getCurrentFile()).getAbsoluteFile();
        int[] lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount};
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        store.setPlateAcquisitionMaximumFieldCount(new PositiveInteger(this.fieldCount), 0, 0);
        this.plateAcqStartTime = DateTools.formatDate(this.plateAcqStartTime, "dd.MM.yyyy  HH:mm:ss");
        store.setPlateAcquisitionStartTime(this.plateAcqStartTime, 0, 0);
        for (int row = 0; row < this.wellRows; ++row) {
            for (int col = 0; col < this.wellColumns; ++col) {
                int well = row * this.wellColumns + col;
                store.setWellID(MetadataTools.createLSID("Well", 0, well), 0, well);
                store.setWellRow(new NonNegativeInteger(row), 0, well);
                store.setWellColumn(new NonNegativeInteger(col), 0, well);
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int[] pos = FormatTools.rasterToPosition(lengths, i);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setImageID(imageID, i);
            int well = this.wellNumber[pos[1]][0] * this.wellColumns + this.wellNumber[pos[1]][1];
            char wellRow = (char)(65 + this.wellNumber[pos[1]][0]);
            store.setImageName("Well " + wellRow + "-" + (this.wellNumber[pos[1]][1] + 1) + "; Field #" + (pos[0] + 1), i);
            if (this.wellRows == 0 && this.wellColumns == 0) {
                well = pos[1];
                NonNegativeInteger row = new NonNegativeInteger(this.wellNumber[pos[1]][0]);
                NonNegativeInteger col = new NonNegativeInteger(this.wellNumber[pos[1]][1]);
                String wellID = MetadataTools.createLSID("Well", pos[2], well);
                store.setWellID(wellID, pos[2], well);
                store.setWellRow(row, pos[2], pos[1]);
                store.setWellColumn(col, pos[2], pos[1]);
            }
            String wellSample = MetadataTools.createLSID("WellSample", pos[2], well, pos[0]);
            store.setWellSampleID(wellSample, pos[2], well, pos[0]);
            store.setWellSampleIndex(new NonNegativeInteger(i), pos[2], well, pos[0]);
            store.setWellSampleImageRef(imageID, pos[2], well, pos[0]);
            store.setPlateAcquisitionWellSampleRef(wellSample, 0, 0, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            if (this.plateName == null) {
                this.plateName = currentFile.getParentFile().getName();
            }
            if (this.plateBarcode != null) {
                this.plateName = this.plateBarcode + " " + this.plateName;
            }
            store.setPlateName(this.plateName, 0);
            store.setPlateRowNamingConvention(this.getNamingConvention("Letter"), 0);
            store.setPlateColumnNamingConvention(this.getNamingConvention("Number"), 0);
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                int[] pos = FormatTools.rasterToPosition(lengths, i);
                store.setImageInstrumentRef(instrumentID, i);
                int seriesIndex = i * this.getImageCount();
                if (seriesIndex < this.objectiveRefs.size()) {
                    store.setImageObjectiveSettingsID(this.objectiveRefs.get(seriesIndex), i);
                }
                if (seriesIndex < this.lightSourceCombinationRefs.size()) {
                    String lightSourceCombo = this.lightSourceCombinationRefs.get(seriesIndex);
                    Vector<String> lightSources = this.lightSourceCombinationIDs.get(lightSourceCombo);
                    for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                        int index = seriesIndex + c;
                        if (index < this.cameraRefs.size()) {
                            store.setDetectorSettingsID(this.cameraRefs.get(index), i, c);
                        }
                        if (index < this.binnings.size()) {
                            store.setDetectorSettingsBinning(this.getBinning(this.binnings.get(index)), i, c);
                        }
                        if (lightSources != null && c < lightSources.size()) {
                            store.setChannelLightSourceSettingsID(lightSources.get(c), i, c);
                        } else if (c > 0 && lightSources != null && lightSources.size() == 1) {
                            lightSourceCombo = this.lightSourceCombinationRefs.get(seriesIndex + c);
                            lightSources = this.lightSourceCombinationIDs.get(lightSourceCombo);
                            store.setChannelLightSourceSettingsID(lightSources.get(0), i, c);
                        }
                        if (index >= this.filterSets.size()) continue;
                        FilterGroup group = this.filterSetMap.get(this.filterSets.get(index));
                        if (group.emission != null) {
                            store.setLightPathEmissionFilterRef(group.emission, i, c, 0);
                        }
                        if (group.excitation != null) {
                            store.setLightPathExcitationFilterRef(group.excitation, i, c, 0);
                        }
                        if (group.dichroic == null) continue;
                        store.setLightPathDichroicRef(group.dichroic, i, c);
                    }
                }
                if (seriesIndex < this.xSizes.size()) {
                    store.setPixelsPhysicalSizeX(new PositiveFloat(this.xSizes.get(seriesIndex)), i);
                }
                if (seriesIndex < this.ySizes.size()) {
                    store.setPixelsPhysicalSizeY(new PositiveFloat(this.ySizes.get(seriesIndex)), i);
                }
                int well = this.wellNumber[pos[1]][0] * this.wellColumns + this.wellNumber[pos[1]][1];
                if (this.wellRows == 0 && this.wellColumns == 0) {
                    well = pos[1];
                }
                if (pos[0] < this.xPositions.size()) {
                    store.setWellSamplePositionX(this.xPositions.get(pos[0]), pos[2], well, pos[0]);
                }
                if (pos[0] >= this.yPositions.size()) continue;
                store.setWellSamplePositionY(this.yPositions.get(pos[0]), pos[2], well, pos[0]);
            }
        }
    }

    private void parseResFile(String id) throws IOException {
        ResHandler handler = new ResHandler();
        String resXML = DataTools.readFile(id);
        XMLTools.parseXML(resXML, (DefaultHandler)handler);
    }

    private int[] getWell(String file2) {
        String name = file2.substring(file2.lastIndexOf(File.separator) + 1);
        if (name.length() == 14) {
            try {
                int row = Integer.parseInt(name.substring(0, 3)) - 1;
                int col = Integer.parseInt(name.substring(3, 6)) - 1;
                return new int[]{row, col};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{0, 0};
    }

    private int firstWellPlanes() {
        int j;
        int i;
        for (i = 0; i < this.offsets.length; ++i) {
            for (j = 0; j < this.offsets[i].length; ++j) {
                if (this.offsets[i][j] == null) continue;
                return this.offsets[i][j].length;
            }
        }
        for (i = 0; i < this.ifds.length; ++i) {
            for (j = 0; j < this.ifds[i].length; ++j) {
                if (this.ifds[i][j] == null) continue;
                return this.ifds[i][j].size();
            }
        }
        return 0;
    }

    private void parseFlexFile(int currentWell, int wellRow, int wellCol, boolean firstFile, MetadataStore store) throws FormatException, IOException {
        int i;
        int i2;
        LOGGER.info("Parsing .flex file (well {}{})", wellRow + 65, (Object)(wellCol + 1));
        if (this.flexFiles[wellRow][wellCol] == null) {
            return;
        }
        if (this.channelNames == null) {
            this.channelNames = new Vector();
        }
        if (this.xPositions == null) {
            this.xPositions = new Vector();
        }
        if (this.yPositions == null) {
            this.yPositions = new Vector();
        }
        if (this.xSizes == null) {
            this.xSizes = new Vector();
        }
        if (this.ySizes == null) {
            this.ySizes = new Vector();
        }
        if (this.cameraIDs == null) {
            this.cameraIDs = new Vector();
        }
        if (this.lightSourceIDs == null) {
            this.lightSourceIDs = new Vector();
        }
        if (this.objectiveIDs == null) {
            this.objectiveIDs = new Vector();
        }
        if (this.lightSourceCombinationIDs == null) {
            this.lightSourceCombinationIDs = new HashMap();
        }
        if (this.lightSourceCombinationRefs == null) {
            this.lightSourceCombinationRefs = new Vector();
        }
        if (this.cameraRefs == null) {
            this.cameraRefs = new Vector();
        }
        if (this.objectiveRefs == null) {
            this.objectiveRefs = new Vector();
        }
        if (this.binnings == null) {
            this.binnings = new Vector();
        }
        if (this.filterSets == null) {
            this.filterSets = new Vector();
        }
        if (this.filterSetMap == null) {
            this.filterSetMap = new HashMap();
        }
        LOGGER.debug("Parsing XML from {}", (Object)this.flexFiles[wellRow][wellCol]);
        int nOffsets = this.offsets[wellRow][wellCol] != null ? this.offsets[wellRow][wellCol].length : 0;
        int oldWellRow = wellRow;
        int oldWellCol = wellCol;
        if (wellRow >= this.ifds.length || wellCol >= this.ifds[wellRow].length) {
            wellRow = 0;
            wellCol = 0;
        }
        IFD ifd = (IFD)this.ifds[wellRow][wellCol].get(0);
        String xml = XMLTools.sanitizeXML(ifd.getIFDStringValue(65200));
        Vector<String> n = new Vector<String>();
        Vector<String> f = new Vector<String>();
        FlexHandler handler = new FlexHandler(n, f, store, firstFile, currentWell);
        LOGGER.info("Parsing XML in .flex file");
        XMLTools.parseXML(xml.getBytes(), (DefaultHandler)handler);
        if (firstFile) {
            this.populateCoreMetadata(oldWellRow, oldWellCol, n);
        }
        int totalPlanes = this.getSeriesCount() * this.getImageCount();
        LOGGER.info("Populating pixel scaling factors");
        int nsize = n.size();
        int fsize = f.size();
        if (nsize != fsize || nsize != totalPlanes) {
            LOGGER.warn("mismatch between image count, names and factors (count={}, names={}, factors={})", new Object[]{totalPlanes, nsize, fsize});
        }
        for (i2 = 0; i2 < nsize; ++i2) {
            this.addGlobalMeta("Name " + i2, n.get(i2));
        }
        for (i2 = 0; i2 < fsize; ++i2) {
            this.addGlobalMeta("Factor " + i2, f.get(i2));
        }
        this.factors[wellRow][wellCol] = new double[totalPlanes];
        int max = 0;
        for (i = 0; i < fsize; ++i) {
            String factor = f.get(i);
            double q = 1.0;
            try {
                q = Double.parseDouble(factor);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("invalid factor #{}: {}", i, (Object)factor);
            }
            if (i >= this.factors[wellRow][wellCol].length) continue;
            this.factors[wellRow][wellCol][i] = q;
            if (!(q > this.factors[wellRow][wellCol][max])) continue;
            max = i;
        }
        if (fsize < this.factors[wellRow][wellCol].length) {
            Arrays.fill(this.factors[wellRow][wellCol], fsize, this.factors[wellRow][wellCol].length, 1.0);
        }
        if (this.factors[wellRow][wellCol][max] > 256.0) {
            this.core[0].pixelType = 5;
        } else if (this.factors[wellRow][wellCol][max] > 1.0) {
            this.core[0].pixelType = 3;
        }
        for (i = 1; i < this.core.length; ++i) {
            this.core[i].pixelType = this.getPixelType();
        }
    }

    private void populateCoreMetadata(int wellRow, int wellCol, Vector<String> imageNames) throws FormatException {
        LOGGER.info("Populating core metadata for well row " + wellRow + ", column " + wellCol);
        if (this.getSizeC() == 0 && this.getSizeT() == 0) {
            Vector<String> uniqueChannels = new Vector<String>();
            for (int i = 0; i < imageNames.size(); ++i) {
                String name = imageNames.get(i);
                String[] tokens = name.split("_");
                if (tokens.length > 1) {
                    int fieldIndex = Integer.parseInt(tokens[0]);
                    if (fieldIndex > this.fieldCount) {
                        this.fieldCount = fieldIndex;
                    }
                } else {
                    tokens = name.split(":");
                }
                String channel = tokens[tokens.length - 1];
                if (uniqueChannels.contains(channel)) continue;
                uniqueChannels.add(channel);
            }
            if (this.fieldCount == 0) {
                this.fieldCount = 1;
            }
            this.core[0].sizeC = Math.max(uniqueChannels.size(), 1);
            if (this.getSizeZ() == 0) {
                this.core[0].sizeZ = 1;
            }
            this.core[0].sizeT = imageNames.size() / (this.fieldCount * this.getSizeC() * this.getSizeZ());
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = Math.max(this.channelNames.size(), 1);
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.plateCount == 0) {
            this.plateCount = 1;
        }
        if (this.wellCount == 0) {
            this.wellCount = 1;
        }
        if (this.fieldCount == 0) {
            this.fieldCount = 1;
        }
        IFDList ifdList = wellRow < this.ifds.length && wellCol < this.ifds[wellRow].length ? this.ifds[wellRow][wellCol] : this.ifds[0][0];
        IFD ifd = (IFD)ifdList.get(0);
        int nPlanes = ifdList.size();
        if (this.offsets[wellRow][wellCol] != null) {
            nPlanes = this.offsets[wellRow][wellCol].length;
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        if (this.getImageCount() * this.fieldCount != nPlanes) {
            this.core[0].imageCount = nPlanes / this.fieldCount;
            this.core[0].sizeZ = 1;
            this.core[0].sizeC = 1;
            this.core[0].sizeT = nPlanes / this.fieldCount;
        }
        this.core[0].sizeX = (int)ifd.getImageWidth();
        this.core[0].sizeY = (int)ifd.getImageLength();
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].littleEndian = ifd.isLittleEndian();
        this.core[0].pixelType = ifd.getPixelType();
        int seriesCount = this.plateCount * this.wellCount * this.fieldCount;
        if (seriesCount > 1) {
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[seriesCount];
            Arrays.fill(this.core, oldCore);
        }
    }

    private String[] findFiles(Location baseFile) throws IOException {
        String[] suffixes = new String[]{};
        if (FlexReader.checkSuffix(baseFile.getName(), FLEX_SUFFIX)) {
            suffixes = new String[]{MEA_SUFFIX, RES_SUFFIX};
            LOGGER.debug("Looking for files with the suffix '{}' or '{}'.", (Object)MEA_SUFFIX, (Object)RES_SUFFIX);
        } else if (FlexReader.checkSuffix(baseFile.getName(), MEA_SUFFIX)) {
            suffixes = new String[]{FLEX_SUFFIX, RES_SUFFIX};
            LOGGER.debug("Looking for files with the suffix '{}' or '{}'.", (Object)FLEX_SUFFIX, (Object)RES_SUFFIX);
        }
        return this.findFiles(baseFile, suffixes);
    }

    private String[] findFiles(Location baseFile, String[] suffixes) throws IOException {
        LOGGER.debug("findFiles({})", (Object)baseFile.getAbsolutePath());
        LOGGER.info("Looking for files that are in the same dataset as " + baseFile.getAbsolutePath());
        Vector<String> fileList = new Vector<String>();
        Location plateDir = baseFile.getParentFile();
        String[] files = plateDir.list(true);
        LOGGER.debug("Looking for files in {}", (Object)plateDir.getAbsolutePath());
        for (String file2 : files) {
            String lfile = file2.toLowerCase();
            String path = new Location(plateDir, file2).getAbsolutePath();
            if (!FlexReader.checkSuffix(file2, suffixes)) continue;
            fileList.add(path);
            LOGGER.debug("Found file {}", (Object)path);
        }
        LOGGER.debug("Checking to see if at least one file with each suffix was found...");
        boolean validList = true;
        for (String suffix : suffixes) {
            boolean foundSuffix = false;
            for (String file3 : fileList) {
                if (!FlexReader.checkSuffix(file3, suffix)) continue;
                foundSuffix = true;
                break;
            }
            if (foundSuffix) continue;
            validList = false;
            break;
        }
        LOGGER.debug("{} required files.", (Object)(validList ? "Found" : "Did not find"));
        if (validList) {
            LOGGER.debug("Returning file list:");
            for (String file4 : fileList) {
                LOGGER.debug("  {}", (Object)file4);
                if (!FlexReader.checkSuffix(file4, MEASUREMENT_SUFFIXES) || this.measurementFiles.contains(file4)) continue;
                this.measurementFiles.add(file4);
            }
            return fileList.toArray(new String[fileList.size()]);
        }
        Location flexDir = null;
        try {
            flexDir = plateDir.getParentFile();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LOGGER.debug("Looking for files in {}", flexDir);
        if (flexDir == null) {
            return null;
        }
        Location measurementDir = null;
        String[] flexDirList = flexDir.list(true);
        if (flexDirList.length > 1) {
            String plateName = plateDir.getName();
            for (String file5 : flexDirList) {
                if (file5.equals(plateName) || !plateName.startsWith(file5) && !file5.startsWith(plateName)) continue;
                measurementDir = new Location(flexDir, file5);
                LOGGER.debug("Expect measurement files to be in {}", (Object)measurementDir.getAbsolutePath());
                break;
            }
        }
        if (measurementDir == null) {
            String[] topDirList;
            Location topDir = flexDir.getParentFile();
            LOGGER.debug("First attempt at finding measurement file directory failed.  Looking for an appropriate measurement directory in {}.", (Object)topDir.getAbsolutePath());
            for (String file6 : topDirList = topDir.list(true)) {
                if (flexDir.getAbsolutePath().endsWith(file6)) continue;
                measurementDir = new Location(topDir, file6);
                LOGGER.debug("Expect measurement files to be in {}", (Object)measurementDir.getAbsolutePath());
                break;
            }
            if (measurementDir == null) {
                LOGGER.debug("Failed to find measurement file directory.");
                return null;
            }
        } else {
            plateDir = measurementDir;
        }
        if (!plateDir.getAbsolutePath().equals(measurementDir.getAbsolutePath())) {
            LOGGER.debug("Measurement files are in a subdirectory of {}", (Object)measurementDir.getAbsolutePath());
            String[] measurementPlates = measurementDir.list(true);
            String plate = plateDir.getName();
            LOGGER.debug("Determining which subdirectory contains the measurements for plate {}", (Object)plate);
            plateDir = null;
            if (measurementPlates != null) {
                for (String file6 : measurementPlates) {
                    LOGGER.debug("Checking {}", (Object)file6);
                    if (file6.indexOf(plate) == -1 && plate.indexOf(file6) == -1) continue;
                    plateDir = new Location(measurementDir, file6);
                    LOGGER.debug("Measurement files are in {}", (Object)plateDir.getAbsolutePath());
                    break;
                }
            }
        }
        if (plateDir == null) {
            LOGGER.debug("Could not find appropriate subdirectory.");
            return null;
        }
        for (String file7 : files = plateDir.list(true)) {
            fileList.add(new Location(plateDir, file7).getAbsolutePath());
        }
        LOGGER.debug("Returning file list:");
        for (String file8 : fileList) {
            LOGGER.debug("  {}", (Object)file8);
            if (!FlexReader.checkSuffix(file8, MEASUREMENT_SUFFIXES) || this.measurementFiles.contains(file8)) continue;
            this.measurementFiles.add(file8);
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    private void groupFiles(String[] fileList, MetadataStore store) throws FormatException, IOException {
        LOGGER.info("Grouping together files in the same dataset");
        HashMap<String, String> v = new HashMap<String, String>();
        Boolean firstCompressed = null;
        for (String file2 : fileList) {
            int[] well;
            boolean compressed;
            RandomAccessInputStream s = new RandomAccessInputStream(file2);
            TiffParser parser = new TiffParser(s);
            IFD firstIFD = parser.getFirstIFD();
            s.close();
            boolean bl = compressed = firstIFD.getCompression() != TiffCompression.UNCOMPRESSED;
            if (firstCompressed == null) {
                firstCompressed = compressed;
            }
            if (compressed == firstCompressed) {
                well = this.getWell(file2);
                if (well[0] > this.nRows) {
                    this.nRows = well[0];
                }
                if (well[1] > this.nCols) {
                    this.nCols = well[1];
                }
                if (fileList.length == 1) {
                    well[0] = 0;
                    well[1] = 0;
                }
            } else {
                v.clear();
                v.put("0,0", this.currentId);
                fileList = new String[]{this.currentId};
                break;
            }
            v.put(well[0] + "," + well[1], file2);
        }
        ++this.nRows;
        ++this.nCols;
        if (fileList.length == 1) {
            this.nRows = 1;
            this.nCols = 1;
        }
        LOGGER.debug("Determined that there are {} rows and {} columns of wells.", this.nRows, (Object)this.nCols);
        this.flexFiles = new String[this.nRows][this.nCols];
        this.offsets = new long[this.nRows][this.nCols][];
        this.wellCount = v.size();
        this.wellNumber = new int[this.wellCount][2];
        RandomAccessInputStream s = null;
        boolean firstFile = true;
        boolean compressed = false;
        int nOffsets = 1;
        int currentWell = 0;
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                this.flexFiles[row][col] = (String)v.get(row + "," + col);
                if (this.flexFiles[row][col] == null) continue;
                this.wellNumber[currentWell][0] = row;
                this.wellNumber[currentWell][1] = col;
                s = new RandomAccessInputStream(new NIOFileHandle(this.flexFiles[row][col], "r"));
                if (currentWell == 0) {
                    this.firstStream = s;
                }
                TiffParser tp = new TiffParser(s);
                if (compressed || firstFile) {
                    LOGGER.info("Parsing IFDs for well {}{}", row + 65, (Object)(col + 1));
                    IFD firstIFD = tp.getFirstIFD();
                    boolean bl = compressed = firstIFD.getCompression() != TiffCompression.UNCOMPRESSED;
                    if (compressed) {
                        if (this.ifds == null) {
                            this.ifds = new IFDList[this.nRows][this.nCols];
                            this.factors = new double[this.nRows][this.nCols][];
                        }
                        tp.setDoCaching(false);
                        this.ifds[row][col] = tp.getIFDs();
                        this.ifds[row][col].set(0, firstIFD);
                        this.parseFlexFile(currentWell, row, col, firstFile, store);
                    } else {
                        if (this.ifds == null) {
                            this.ifds = new IFDList[1][1];
                            this.factors = new double[1][1][];
                        }
                        this.offsets[row][col] = tp.getIFDOffsets();
                        nOffsets = this.offsets[row][col].length;
                        this.ifds[0][0] = new IFDList();
                        this.ifds[0][0].add(firstIFD);
                        this.parseFlexFile(currentWell, row, col, firstFile, store);
                    }
                } else {
                    LOGGER.info("Retrieving IFD offsets for well {}{}", row + 65, (Object)(col + 1));
                    this.offsets[row][col] = new long[nOffsets];
                    this.offsets[row][col][0] = tp.getFirstOffset();
                    if (this.offsets[row][col].length > 1) {
                        s.seek(this.offsets[row][col][0]);
                        s.skipBytes(s.readShort() * 12);
                        this.offsets[row][col][1] = s.readInt();
                        int size = FormatTools.getPlaneSize(this) + 174;
                        for (int i = 2; i < this.offsets[row][col].length; ++i) {
                            this.offsets[row][col][i] = this.offsets[row][col][i - 1] + (long)size;
                        }
                    }
                    this.parseFlexFile(currentWell, row, col, firstFile, store);
                }
                if (currentWell != 0) {
                    s.close();
                }
                if (firstFile) {
                    firstFile = false;
                }
                ++currentWell;
            }
        }
    }

    public static void appendServerMap(String alias, String realName) throws FormatException {
        LOGGER.debug("appendServerMap({}, {})", (Object)alias, (Object)realName);
        if (alias != null) {
            if (realName == null) {
                LOGGER.debug("removing mapping for {}", (Object)alias);
                serverMap.remove(alias);
            } else {
                Location server = new Location(realName);
                if (!server.exists()) {
                    throw new FormatException("Server " + realName + " was not found.");
                }
                String[] names = serverMap.get(alias);
                if (names == null) {
                    serverMap.put(alias, new String[]{realName});
                } else {
                    String[] tmpNames = new String[names.length + 1];
                    System.arraycopy(names, 0, tmpNames, 0, names.length);
                    tmpNames[tmpNames.length - 1] = realName;
                    serverMap.put(alias, tmpNames);
                }
            }
        }
    }

    public static void mapServer(String alias, String realName) {
        LOGGER.debug("mapSever({}, {})", (Object)alias, (Object)realName);
        if (alias != null) {
            if (realName == null) {
                LOGGER.debug("removing mapping for {}", (Object)alias);
                serverMap.remove(alias);
            } else {
                String baseName;
                LOGGER.debug("Finding base server name...");
                if (realName.endsWith(File.separator)) {
                    realName = realName.substring(0, realName.length() - 1);
                }
                if ((baseName = realName).endsWith(SCREENING)) {
                    baseName = baseName.substring(0, baseName.lastIndexOf(SCREENING));
                } else if (baseName.endsWith(ARCHIVE)) {
                    baseName = baseName.substring(0, baseName.lastIndexOf(ARCHIVE));
                }
                LOGGER.debug("Base server name is {}", (Object)baseName);
                Vector<String> names = new Vector<String>();
                names.add(realName);
                Location screening = new Location(baseName + File.separator + SCREENING);
                Location archive = new Location(baseName + File.separator + ARCHIVE);
                if (screening.exists()) {
                    names.add(screening.getAbsolutePath());
                }
                if (archive.exists()) {
                    names.add(archive.getAbsolutePath());
                }
                LOGGER.debug("Server names for {}:", (Object)alias);
                for (String name : names) {
                    LOGGER.debug("  {}", (Object)name);
                }
                FlexReader.mapServer(alias, names.toArray(new String[names.size()]));
            }
        }
    }

    public static void mapServer(String alias, String[] realNames) {
        StringBuffer msg = new StringBuffer("mapServer(");
        msg.append(alias);
        if (realNames != null) {
            msg.append(", [");
            for (String name : realNames) {
                msg.append(name);
                msg.append(", ");
            }
            msg.append("])");
        } else {
            msg.append(", null)");
        }
        LOGGER.debug(msg.toString());
        if (alias != null) {
            if (realNames == null) {
                LOGGER.debug("Removing mapping for {}", (Object)alias);
                serverMap.remove(alias);
            } else {
                for (String server : realNames) {
                    try {
                        FlexReader.appendServerMap(alias, server);
                    }
                    catch (FormatException e) {
                        LOGGER.debug("Failed to map server '{}'", (Object)server, (Object)e);
                    }
                }
            }
        }
    }

    public static void mapServersFromConfigurationFile(String configFile) throws FormatException, IOException {
        String[] lines;
        LOGGER.debug("mapServersFromConfigurationFile({})", (Object)configFile);
        Location file2 = new Location(configFile);
        if (!file2.exists()) {
            throw new FormatException("Configuration file " + configFile + " does not exist.");
        }
        for (String line : lines = DataTools.readFile(configFile).split("[\r\n]")) {
            LOGGER.trace(line);
            int eq = line.indexOf("=");
            if (eq == -1 || line.startsWith("#")) continue;
            String alias = line.substring(0, eq).trim();
            String[] servers = line.substring(eq + 1).trim().split(";");
            FlexReader.mapServer(alias, servers);
        }
    }

    class FilterGroup {
        public String emission;
        public String excitation;
        public String dichroic;
        public String id;

        FilterGroup() {
        }
    }

    public class ResHandler
    extends DefaultHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("AnalysisResults")) {
                FlexReader.this.plateAcqStartTime = attributes.getValue("date");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MeaHandler
    extends DefaultHandler {
        private Vector<String> flex = new Vector();
        private String[] hostnames = null;

        public Vector<String> getFlexFiles() {
            return this.flex;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Host")) {
                String hostname = attributes.getValue("name");
                LOGGER.debug("FlexHandler: found hostname '{}'", (Object)hostname);
                this.hostnames = (String[])serverMap.get(hostname);
                if (this.hostnames != null) {
                    LOGGER.debug("Sanitizing hostnames...");
                    for (int i = 0; i < this.hostnames.length; ++i) {
                        String host = this.hostnames[i];
                        this.hostnames[i] = this.hostnames[i].replace('/', File.separatorChar);
                        this.hostnames[i] = this.hostnames[i].replace('\\', File.separatorChar);
                        LOGGER.debug("Hostname #{} was {}, is now {}", new Object[]{i, host, this.hostnames[i]});
                    }
                }
            } else if (qName.equals("Picture")) {
                String path = attributes.getValue("path");
                if (!path.endsWith(".flex")) {
                    path = path + ".flex";
                }
                path = path.replace('/', File.separatorChar);
                path = path.replace('\\', File.separatorChar);
                LOGGER.debug("Found .flex in .mea: {}", (Object)path);
                if (this.hostnames != null) {
                    int numberOfFlexFiles = this.flex.size();
                    for (String hostname : this.hostnames) {
                        String filename = hostname + File.separator + path;
                        if (!new Location(filename).exists()) continue;
                        this.flex.add(filename);
                    }
                    if (this.flex.size() == numberOfFlexFiles) {
                        LOGGER.warn("{} was in .mea, but does not actually exist.", (Object)path);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FlexHandler
    extends DefaultHandler {
        private Vector<String> names;
        private Vector<String> factors;
        private MetadataStore store;
        private int nextLaser = -1;
        private int nextCamera = 0;
        private int nextObjective = -1;
        private int nextImage = 0;
        private int nextPlate = 0;
        private String parentQName;
        private String lightSourceID;
        private String sliderName;
        private int nextFilter;
        private int nextDichroic;
        private int nextFilterSet;
        private int nextSliderRef;
        private boolean populateCore = true;
        private int well = 0;
        private HashMap<String, String> filterMap;
        private HashMap<String, String> dichroicMap;
        private MetadataLevel level;
        private String filterSet;
        private StringBuffer charData = new StringBuffer();

        public FlexHandler(Vector<String> names, Vector<String> factors, MetadataStore store, boolean populateCore, int well) {
            this.names = names;
            this.factors = factors;
            this.store = store;
            this.populateCore = populateCore;
            this.well = well;
            this.filterMap = new HashMap();
            this.dichroicMap = new HashMap();
            this.level = FlexReader.this.getMetadataOptions().getMetadataLevel();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charData.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            int seriesCount;
            int currentImage;
            int currentSeries;
            int nImages;
            String value = this.charData.toString();
            this.charData = new StringBuffer();
            if (qName.equals("XSize") && "Plate".equals(this.parentQName)) {
                FlexReader.this.wellRows = Integer.parseInt(value);
            } else if (qName.equals("YSize") && "Plate".equals(this.parentQName)) {
                FlexReader.this.wellColumns = Integer.parseInt(value);
            } else if ("Image".equals(this.parentQName)) {
                if (FlexReader.this.fieldCount == 0) {
                    FlexReader.this.fieldCount = 1;
                }
                if ((nImages = FlexReader.this.firstWellPlanes() / FlexReader.this.fieldCount) == 0) {
                    nImages = 1;
                }
                currentSeries = (this.nextImage - 1) / nImages;
                currentSeries += this.well * FlexReader.this.fieldCount;
                currentImage = (this.nextImage - 1) % nImages;
                seriesCount = 1;
                if (FlexReader.this.plateCount > 0) {
                    seriesCount *= FlexReader.this.plateCount;
                }
                if (FlexReader.this.wellCount > 0) {
                    seriesCount *= FlexReader.this.wellCount;
                }
                if (FlexReader.this.fieldCount > 0) {
                    seriesCount *= FlexReader.this.fieldCount;
                }
                if (currentSeries >= seriesCount) {
                    return;
                }
                if (qName.equals("DateTime")) {
                    this.store.setImageAcquiredDate(value, currentSeries);
                }
            }
            if (this.level == MetadataLevel.MINIMUM) {
                return;
            }
            if (qName.equals("Image")) {
                FlexReader.this.binnings.add(FlexReader.this.binX + "x" + FlexReader.this.binY);
            } else if (qName.equals("PlateName")) {
                if (FlexReader.this.plateName == null) {
                    FlexReader.this.plateName = value;
                }
            } else if (qName.equals("Barcode")) {
                if (FlexReader.this.plateBarcode == null) {
                    FlexReader.this.plateBarcode = value;
                }
                this.store.setPlateExternalIdentifier(value, this.nextPlate - 1);
            } else if (qName.equals("Wavelength")) {
                String lsid = MetadataTools.createLSID("LightSource", 0, this.nextLaser);
                this.store.setLaserID(lsid, 0, this.nextLaser);
                this.store.setLaserWavelength(new PositiveInteger(new Integer(value)), 0, this.nextLaser);
                try {
                    this.store.setLaserType(FlexReader.this.getLaserType("Other"), 0, this.nextLaser);
                    this.store.setLaserLaserMedium(FlexReader.this.getLaserMedium("Other"), 0, this.nextLaser);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
            } else if (qName.equals("Magnification")) {
                this.store.setObjectiveCalibratedMagnification(new Double(value), 0, this.nextObjective);
            } else if (qName.equals("NumAperture")) {
                this.store.setObjectiveLensNA(new Double(value), 0, this.nextObjective);
            } else if (qName.equals("Immersion")) {
                String immersion = "Other";
                if (value.equals("1.33")) {
                    immersion = "Water";
                } else if (value.equals("1.00")) {
                    immersion = "Air";
                } else {
                    LOGGER.warn("Unknown immersion medium: {}", (Object)value);
                }
                try {
                    this.store.setObjectiveImmersion(FlexReader.this.getImmersion(immersion), 0, this.nextObjective);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
            } else if (qName.equals("OffsetX") || qName.equals("OffsetY")) {
                Double offset = new Double(Double.parseDouble(value) * 1000000.0);
                if (qName.equals("OffsetX")) {
                    FlexReader.this.xPositions.add(offset);
                } else {
                    FlexReader.this.yPositions.add(offset);
                }
            } else if ("Image".equals(this.parentQName)) {
                if (FlexReader.this.fieldCount == 0) {
                    FlexReader.this.fieldCount = 1;
                }
                if ((nImages = FlexReader.this.firstWellPlanes() / FlexReader.this.fieldCount) == 0) {
                    nImages = 1;
                }
                currentSeries = (this.nextImage - 1) / nImages;
                currentSeries += this.well * FlexReader.this.fieldCount;
                currentImage = (this.nextImage - 1) % nImages;
                seriesCount = 1;
                if (FlexReader.this.plateCount > 0) {
                    seriesCount *= FlexReader.this.plateCount;
                }
                if (FlexReader.this.wellCount > 0) {
                    seriesCount *= FlexReader.this.wellCount;
                }
                if (FlexReader.this.fieldCount > 0) {
                    seriesCount *= FlexReader.this.fieldCount;
                }
                if (currentSeries >= seriesCount) {
                    return;
                }
                if (qName.equals("CameraBinningX")) {
                    FlexReader.this.binX = Integer.parseInt(value);
                } else if (qName.equals("CameraBinningY")) {
                    FlexReader.this.binY = Integer.parseInt(value);
                } else if (qName.equals("ObjectiveRef")) {
                    String objectiveID = MetadataTools.createLSID("Objective", 0, FlexReader.this.objectiveIDs.indexOf(value));
                    FlexReader.this.objectiveRefs.add(objectiveID);
                } else if (qName.equals("CameraRef")) {
                    String detectorID = MetadataTools.createLSID("Detector", 0, FlexReader.this.cameraIDs.indexOf(value));
                    FlexReader.this.cameraRefs.add(detectorID);
                } else if (qName.equals("ImageResolutionX")) {
                    double v = Double.parseDouble(value) * 1000000.0;
                    FlexReader.this.xSizes.add(new Double(v));
                } else if (qName.equals("ImageResolutionY")) {
                    double v = Double.parseDouble(value) * 1000000.0;
                    FlexReader.this.ySizes.add(new Double(v));
                } else if (qName.equals("PositionX")) {
                    Double v = new Double(Double.parseDouble(value) * 1000000.0);
                    this.store.setPlanePositionX(v, currentSeries, currentImage);
                    FlexReader.this.addGlobalMeta("X position for position #" + (currentSeries + 1), v);
                } else if (qName.equals("PositionY")) {
                    Double v = new Double(Double.parseDouble(value) * 1000000.0);
                    this.store.setPlanePositionY(v, currentSeries, currentImage);
                    FlexReader.this.addGlobalMeta("Y position for position #" + (currentSeries + 1), v);
                } else if (qName.equals("PositionZ")) {
                    Double v = new Double(Double.parseDouble(value) * 1000000.0);
                    this.store.setPlanePositionZ(v, currentSeries, currentImage);
                    FlexReader.this.addGlobalMeta("Z position for position #" + (currentSeries + 1), v);
                } else if (qName.equals("TimepointOffsetUsed")) {
                    this.store.setPlaneDeltaT(new Double(value), currentSeries, currentImage);
                } else if (qName.equals("CameraExposureTime")) {
                    this.store.setPlaneExposureTime(new Double(value), currentSeries, currentImage);
                } else if (qName.equals("LightSourceCombinationRef")) {
                    FlexReader.this.lightSourceCombinationRefs.add(value);
                } else if (qName.equals("FilterCombinationRef")) {
                    FlexReader.this.filterSets.add("FilterSet:" + value);
                }
            } else if (qName.equals("FilterCombination")) {
                ++this.nextFilterSet;
                this.nextSliderRef = 0;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Array")) {
                int len = attributes.getLength();
                for (int i = 0; i < len; ++i) {
                    String name = attributes.getQName(i);
                    if (name.equals("Name")) {
                        this.names.add(attributes.getValue(i));
                        continue;
                    }
                    if (!name.equals("Factor")) continue;
                    this.factors.add(attributes.getValue(i));
                }
            } else if (qName.equals("LightSource") && this.level != MetadataLevel.MINIMUM) {
                this.parentQName = qName;
                String type = attributes.getValue("LightSourceType");
                FlexReader.this.lightSourceIDs.add(attributes.getValue("ID"));
                ++this.nextLaser;
            } else if (qName.equals("LightSourceCombination") && this.level != MetadataLevel.MINIMUM) {
                this.lightSourceID = attributes.getValue("ID");
                FlexReader.this.lightSourceCombinationIDs.put(this.lightSourceID, new Vector());
            } else if (qName.equals("LightSourceRef") && this.level != MetadataLevel.MINIMUM) {
                Vector v = (Vector)FlexReader.this.lightSourceCombinationIDs.get(this.lightSourceID);
                if (v != null) {
                    int id = FlexReader.this.lightSourceIDs.indexOf(attributes.getValue("ID"));
                    String lightSourceID = MetadataTools.createLSID("LightSource", 0, id);
                    v.add(lightSourceID);
                    FlexReader.this.lightSourceCombinationIDs.put(lightSourceID, v);
                }
            } else if (qName.equals("Camera") && this.level != MetadataLevel.MINIMUM) {
                this.parentQName = qName;
                String detectorID = MetadataTools.createLSID("Detector", 0, this.nextCamera);
                this.store.setDetectorID(detectorID, 0, this.nextCamera);
                try {
                    this.store.setDetectorType(FlexReader.this.getDetectorType(attributes.getValue("CameraType")), 0, this.nextCamera);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
                FlexReader.this.cameraIDs.add(attributes.getValue("ID"));
                ++this.nextCamera;
            } else if (qName.equals("Objective") && this.level != MetadataLevel.MINIMUM) {
                this.parentQName = qName;
                String objectiveID = MetadataTools.createLSID("Objective", 0, ++this.nextObjective);
                this.store.setObjectiveID(objectiveID, 0, this.nextObjective);
                try {
                    this.store.setObjectiveCorrection(FlexReader.this.getCorrection("Other"), 0, this.nextObjective);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
                FlexReader.this.objectiveIDs.add(attributes.getValue("ID"));
            } else if (qName.equals("Field")) {
                this.parentQName = qName;
                int fieldNo = Integer.parseInt(attributes.getValue("No"));
                if (fieldNo > FlexReader.this.fieldCount && FlexReader.this.fieldCount < FlexReader.this.firstWellPlanes()) {
                    FlexReader.this.fieldCount++;
                }
            } else if (qName.equals("Plane")) {
                this.parentQName = qName;
                int planeNo = Integer.parseInt(attributes.getValue("No"));
                if (planeNo > FlexReader.this.getSizeZ() && this.populateCore) {
                    ++((FlexReader)FlexReader.this).core[0].sizeZ;
                }
            } else if (qName.equals("WellShape")) {
                this.parentQName = qName;
            } else if (qName.equals("Image")) {
                this.parentQName = qName;
                ++this.nextImage;
                if (this.level != MetadataLevel.MINIMUM) {
                    String x = attributes.getValue("CameraBinningX");
                    String y = attributes.getValue("CameraBinningY");
                    if (x != null) {
                        FlexReader.this.binX = Integer.parseInt(x);
                    }
                    if (y != null) {
                        FlexReader.this.binY = Integer.parseInt(y);
                    }
                }
            } else if (qName.equals("Plate")) {
                this.parentQName = qName;
                if (qName.equals("Plate")) {
                    ++this.nextPlate;
                    FlexReader.this.plateCount++;
                }
            } else if (qName.equals("WellCoordinate")) {
                if (FlexReader.this.wellNumber.length == 1) {
                    ((FlexReader)FlexReader.this).wellNumber[0][0] = Integer.parseInt(attributes.getValue("Row")) - 1;
                    ((FlexReader)FlexReader.this).wellNumber[0][1] = Integer.parseInt(attributes.getValue("Col")) - 1;
                }
            } else if (qName.equals("Slider") && this.level != MetadataLevel.MINIMUM) {
                this.sliderName = attributes.getValue("Name");
            } else if (qName.equals("Filter") && this.level != MetadataLevel.MINIMUM) {
                String id = attributes.getValue("ID");
                if (this.sliderName.endsWith("Dichro")) {
                    String dichroicID = MetadataTools.createLSID("Dichroic", 0, this.nextDichroic);
                    this.dichroicMap.put(id, dichroicID);
                    this.store.setDichroicID(dichroicID, 0, this.nextDichroic);
                    this.store.setDichroicModel(id, 0, this.nextDichroic);
                    ++this.nextDichroic;
                } else {
                    String filterID = MetadataTools.createLSID("Filter", 0, this.nextFilter);
                    this.filterMap.put(id, filterID);
                    this.store.setFilterID(filterID, 0, this.nextFilter);
                    this.store.setFilterModel(id, 0, this.nextFilter);
                    this.store.setFilterFilterWheel(this.sliderName, 0, this.nextFilter);
                    ++this.nextFilter;
                }
            } else if (qName.equals("FilterCombination") && this.level != MetadataLevel.MINIMUM) {
                this.filterSet = "FilterSet:" + attributes.getValue("ID");
                FlexReader.this.filterSetMap.put(this.filterSet, new FilterGroup());
            } else if (qName.equals("SliderRef") && this.level != MetadataLevel.MINIMUM) {
                String filterName = attributes.getValue("Filter");
                String slider = attributes.getValue("ID");
                FilterGroup group = (FilterGroup)FlexReader.this.filterSetMap.get(this.filterSet);
                if (this.nextSliderRef == 0 && slider.startsWith("Camera")) {
                    group.emission = this.filterMap.get(filterName);
                } else if (this.nextSliderRef == 1 && slider.startsWith("Camera")) {
                    group.excitation = this.filterMap.get(filterName);
                } else if (slider.equals("Primary_Dichro")) {
                    group.dichroic = this.dichroicMap.get(filterName);
                }
                String lname = filterName.toLowerCase();
                if (!lname.startsWith("empty") && !lname.startsWith("blocked")) {
                    ++this.nextSliderRef;
                }
                FlexReader.this.filterSetMap.put(this.filterSet, group);
            }
        }
    }
}

