/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.common.xml.XMLTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataConverter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.services.OMEXMLService;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OME;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.XMLAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEXMLServiceImpl
extends AbstractService
implements OMEXMLService {
    public static final String NO_OME_XML_MSG = "ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.loci.wisc.edu/bio-formats/bio-formats-java-library";
    private static final Logger LOGGER = LoggerFactory.getLogger(OMEXMLService.class);
    private static final Templates reorderXSLT = XMLTools.getStylesheet("/loci/formats/meta/reorder-2008-09.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_2003FC = XMLTools.getStylesheet("/loci/formats/meta/2003-FC-to-2008-09.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_2006LO = XMLTools.getStylesheet("/loci/formats/meta/2006-LO-to-2008-09.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_200706 = XMLTools.getStylesheet("/loci/formats/meta/2007-06-to-2008-09.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_200802 = XMLTools.getStylesheet("/loci/formats/meta/2008-02-to-2008-09.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_200809 = XMLTools.getStylesheet("/loci/formats/meta/2008-09-to-2009-09.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_200909 = XMLTools.getStylesheet("/loci/formats/meta/2009-09-to-2010-04.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_201004 = XMLTools.getStylesheet("/loci/formats/meta/2010-04-to-2010-06.xsl", OMEXMLServiceImpl.class);
    private static final Templates UPDATE_201006 = XMLTools.getStylesheet("/loci/formats/meta/2010-06-to-2011-06.xsl", OMEXMLServiceImpl.class);
    private static final String SCHEMA_PATH = "http://www.openmicroscopy.org/Schemas/OME/";

    public OMEXMLServiceImpl() {
        this.checkClassDependency(OMEModelObject.class);
    }

    @Override
    public String getLatestVersion() {
        return "2011-06";
    }

    @Override
    public String transformToLatestVersion(String xml) throws ServiceException {
        String version = this.getOMEXMLVersion(xml);
        if (version.equals(this.getLatestVersion())) {
            return xml;
        }
        LOGGER.debug("Attempting to update XML with version: {}", (Object)version);
        LOGGER.trace("Initial dump: {}", (Object)xml);
        String transformed = null;
        try {
            if (version.equals("2003-FC")) {
                xml = this.verifyOMENamespace(xml);
                transformed = XMLTools.transformXML(xml, UPDATE_2003FC);
            } else if (version.equals("2006-LO")) {
                xml = this.verifyOMENamespace(xml);
                transformed = XMLTools.transformXML(xml, UPDATE_2006LO);
            } else if (version.equals("2007-06")) {
                xml = this.verifyOMENamespace(xml);
                transformed = XMLTools.transformXML(xml, UPDATE_200706);
            } else if (version.equals("2008-02")) {
                xml = this.verifyOMENamespace(xml);
                transformed = XMLTools.transformXML(xml, UPDATE_200802);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2008-09");
            LOGGER.trace("At least 2008-09 dump: {}", (Object)transformed);
            if (!(version.equals("2009-09") || version.equals("2010-04") || version.equals("2010-06"))) {
                transformed = this.verifyOMENamespace(transformed);
                transformed = XMLTools.transformXML(transformed, UPDATE_200809);
            }
            LOGGER.debug("XML updated to at least 2009-09");
            LOGGER.trace("At least 2009-09 dump: {}", (Object)transformed);
            if (!version.equals("2010-04") && !version.equals("2010-06")) {
                transformed = this.verifyOMENamespace(transformed);
                transformed = XMLTools.transformXML(transformed, UPDATE_200909);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2010-04");
            LOGGER.trace("At least 2010-04 dump: {}", (Object)transformed);
            if (!version.equals("2010-04")) {
                transformed = this.verifyOMENamespace(transformed);
                transformed = XMLTools.transformXML(transformed, UPDATE_201004);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2010-06");
            transformed = this.verifyOMENamespace(transformed);
            transformed = XMLTools.transformXML(transformed, UPDATE_201006);
            LOGGER.debug("XML updated to at least 2011-06");
            transformed = transformed.replaceAll("<ns.*?:", "<");
            transformed = transformed.replaceAll("xmlns:ns.*?=", "xmlns:OME=");
            transformed = transformed.replaceAll("</ns.*?:", "</");
            LOGGER.trace("Transformed XML dump: {}", (Object)transformed);
            return transformed;
        }
        catch (IOException e) {
            LOGGER.warn("Could not transform version " + version + " OME-XML.");
            return null;
        }
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata() throws ServiceException {
        return this.createOMEXMLMetadata(null);
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata(String xml) throws ServiceException {
        return this.createOMEXMLMetadata(xml, null);
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata(String xml, String version) throws ServiceException {
        if (xml != null) {
            xml = XMLTools.sanitizeXML(xml);
        }
        OMEModelObject ome = xml == null ? null : this.createRoot(this.transformToLatestVersion(xml));
        OMEXMLMetadataImpl meta = new OMEXMLMetadataImpl();
        if (ome != null) {
            meta.setRoot(ome);
        }
        return meta;
    }

    @Override
    public Object createOMEXMLRoot(String xml) throws ServiceException {
        return this.createRoot(this.transformToLatestVersion(xml));
    }

    @Override
    public boolean isOMEXMLMetadata(Object o) {
        return o instanceof OMEXMLMetadata;
    }

    @Override
    public boolean isOMEXMLRoot(Object o) {
        return o instanceof OMEModelObject;
    }

    private OMEModelObject createRoot(String xml) throws ServiceException {
        try {
            OMEModelImpl model = new OMEModelImpl();
            OME ome = new OME(XMLTools.parseDOM(xml).getDocumentElement(), model);
            model.resolveReferences();
            return ome;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String getOMEXMLVersion(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof OMEXMLMetadata || o instanceof OMEModelObject) {
            return "2011-06";
        }
        if (o instanceof String) {
            String xml = (String)o;
            try {
                Element e = XMLTools.parseDOM(xml).getDocumentElement();
                String namespace = e.getAttribute("xmlns");
                if (namespace == null || namespace.equals("")) {
                    namespace = e.getAttribute("xmlns:ome");
                }
                return namespace.endsWith("ome.xsd") ? "2003-FC" : namespace.substring(namespace.lastIndexOf("/") + 1);
            }
            catch (ParserConfigurationException pce) {
            }
            catch (SAXException se) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public OMEXMLMetadata getOMEMetadata(MetadataRetrieve src) throws ServiceException {
        if (src instanceof OMEXMLMetadata) {
            return (OMEXMLMetadata)src;
        }
        OMEXMLMetadata omexmlMeta = this.createOMEXMLMetadata();
        this.convertMetadata(src, (MetadataStore)omexmlMeta);
        return omexmlMeta;
    }

    @Override
    public String getOMEXML(MetadataRetrieve src) throws ServiceException {
        OMEXMLMetadata omexmlMeta = this.getOMEMetadata(src);
        String xml = omexmlMeta.dumpXML();
        Document doc = null;
        Exception exception = null;
        try {
            doc = XMLTools.parseDOM(xml);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.info("Malformed OME-XML", exception);
            return null;
        }
        Element root = doc.getDocumentElement();
        root.setAttribute("xmlns", SCHEMA_PATH + this.getLatestVersion());
        try {
            xml = XMLTools.getXML(doc);
        }
        catch (TransformerConfigurationException exc) {
            exception = exc;
        }
        catch (TransformerException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.info("Internal XML conversion error", exception);
            return null;
        }
        return xml;
    }

    @Override
    public boolean validateOMEXML(String xml) {
        return this.validateOMEXML(xml, false);
    }

    @Override
    public boolean validateOMEXML(String xml, boolean pixelsHack) {
        if (pixelsHack) {
            Document doc = null;
            Exception exception = null;
            try {
                doc = XMLTools.parseDOM(xml);
            }
            catch (ParserConfigurationException exc) {
                exception = exc;
            }
            catch (SAXException exc) {
                exception = exc;
            }
            catch (IOException exc) {
                exception = exc;
            }
            if (exception != null) {
                LOGGER.info("Malformed OME-XML", exception);
                return false;
            }
            NodeList list = doc.getElementsByTagName("Pixels");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NodeList children = node.getChildNodes();
                boolean needsTiffData = true;
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    String name = child.getLocalName();
                    if (!"TiffData".equals(name) && !"BinData".equals(name)) continue;
                    needsTiffData = false;
                    break;
                }
                if (!needsTiffData) continue;
                Element tiffData = doc.createElement("TiffData");
                node.insertBefore(tiffData, node.getFirstChild());
            }
            try {
                xml = XMLTools.getXML(doc);
            }
            catch (TransformerConfigurationException exc) {
                exception = exc;
            }
            catch (TransformerException exc) {
                exception = exc;
            }
            if (exception != null) {
                LOGGER.info("Internal XML conversion error", exception);
                return false;
            }
        }
        return XMLTools.validateXML(xml, "OME-XML");
    }

    @Override
    public void populateOriginalMetadata(OMEXMLMetadata omexmlMeta, Hashtable<String, Object> metadata) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        int annotationIndex = annotations.sizeOfXMLAnnotationList();
        for (String key : metadata.keySet()) {
            OriginalMetadataAnnotation annotation = new OriginalMetadataAnnotation();
            annotation.setID(MetadataTools.createLSID("Annotation", annotationIndex++));
            annotation.setKey(key);
            annotation.setValue(metadata.get(key).toString());
            annotations.addXMLAnnotation(annotation);
        }
        root.setStructuredAnnotations(annotations);
        omexmlMeta.setRoot(root);
    }

    @Override
    public void populateOriginalMetadata(OMEXMLMetadata omexmlMeta, String key, String value) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        int annotationIndex = annotations.sizeOfXMLAnnotationList();
        OriginalMetadataAnnotation annotation = new OriginalMetadataAnnotation();
        annotation.setID(MetadataTools.createLSID("Annotation", annotationIndex));
        annotation.setKey(key);
        annotation.setValue(value);
        annotations.addXMLAnnotation(annotation);
        root.setStructuredAnnotations(annotations);
        omexmlMeta.setRoot(root);
    }

    @Override
    public void convertMetadata(String xml, MetadataStore dest) throws ServiceException {
        String storeVersion;
        OMEModelObject ome = this.createRoot(this.transformToLatestVersion(xml));
        String rootVersion = this.getOMEXMLVersion(ome);
        if (rootVersion.equals(storeVersion = this.getOMEXMLVersion(dest))) {
            if (!(dest instanceof OMEXMLMetadata)) {
                throw new IllegalArgumentException("Expecting OMEXMLMetadata instance.");
            }
            dest.setRoot(ome);
        } else {
            OMEXMLMetadata src = this.createOMEXMLMetadata(xml);
            this.convertMetadata(src, dest);
        }
    }

    @Override
    public void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        MetadataConverter.convertMetadata(src, dest);
    }

    @Override
    public void removeBinData(OMEXMLMetadata omexmlMeta) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        List<Image> images = root.copyImageList();
        for (Image img : images) {
            Pixels pix = img.getPixels();
            List<BinData> binData = pix.copyBinDataList();
            for (BinData bin : binData) {
                pix.removeBinData(bin);
            }
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void removeChannels(OMEXMLMetadata omexmlMeta, int image, int sizeC) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        Pixels img = root.getImage(image).getPixels();
        List<Channel> channels = img.copyChannelList();
        for (int c = 0; c < channels.size(); ++c) {
            Channel channel = channels.get(c);
            if (channel.getID() != null && c < sizeC) continue;
            img.removeChannel(channel);
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void addMetadataOnly(OMEXMLMetadata omexmlMeta, int image) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        MetadataOnly meta = new MetadataOnly();
        OME root = (OME)omexmlMeta.getRoot();
        Pixels pix = root.getImage(image).getPixels();
        pix.setMetadataOnly(meta);
        omexmlMeta.setRoot(root);
    }

    @Override
    public MetadataStore asStore(MetadataRetrieve meta) {
        return meta instanceof MetadataStore ? (MetadataStore)((Object)meta) : null;
    }

    @Override
    public MetadataRetrieve asRetrieve(MetadataStore meta) {
        return meta instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)meta) : null;
    }

    private String verifyOMENamespace(String xml) {
        try {
            Document doc = XMLTools.parseDOM(xml);
            Element e = doc.getDocumentElement();
            String omeNamespace = e.getAttribute("xmlns:ome");
            if (omeNamespace == null || omeNamespace.equals("")) {
                e.setAttribute("xmlns:ome", e.getAttribute("xmlns"));
            }
            return XMLTools.getXML(doc);
        }
        catch (ParserConfigurationException pce) {
        }
        catch (TransformerConfigurationException tce) {
        }
        catch (TransformerException te) {
        }
        catch (SAXException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    class OriginalMetadataAnnotation
    extends XMLAnnotation {
        private static final String ORIGINAL_METADATA_NS = "openmicroscopy.org/OriginalMetadata";
        private String key;
        private String value;

        OriginalMetadataAnnotation() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        protected Element asXMLElement(Document document, Element element) {
            if (element == null) {
                element = document.createElementNS("http://www.openmicroscopy.org/Schemas/SA/2011-06", "XMLAnnotation");
            }
            Element keyElement = document.createElementNS(ORIGINAL_METADATA_NS, "Key");
            Element valueElement = document.createElementNS(ORIGINAL_METADATA_NS, "Value");
            keyElement.setTextContent(this.key);
            valueElement.setTextContent(this.value);
            Element originalMetadata = document.createElementNS(ORIGINAL_METADATA_NS, "OriginalMetadata");
            originalMetadata.appendChild(keyElement);
            originalMetadata.appendChild(valueElement);
            Element annotationValue = document.createElementNS("http://www.openmicroscopy.org/Schemas/SA/2011-06", "Value");
            annotationValue.appendChild(originalMetadata);
            element.appendChild(annotationValue);
            return super.asXMLElement(document, element);
        }
    }
}

