/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Group;
import ome.xml.model.GroupRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Project.class);
    private String name;
    private String id;
    private String description;
    private Experimenter experimenter;
    private Group group;
    private List<Annotation> annotationList = new ArrayList<Annotation>();
    private List<Dataset> dataset_BackReferenceList = new ArrayList<Dataset>();

    public Project() {
    }

    public Project(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Project".equals(tagName)) {
            LOGGER.debug("Expecting node name of Project got {}", (Object)tagName);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Project missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Project.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = Project.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> GroupRef_nodeList = Project.getChildrenByTagName(element, "GroupRef");
        for (Element GroupRef_element : GroupRef_nodeList) {
            GroupRef group_reference = new GroupRef();
            group_reference.setID(GroupRef_element.getAttribute("ID"));
            model.addReference(this, group_reference);
        }
        List<Element> AnnotationRef_nodeList = Project.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkProject(this);
            this.experimenter = o_casted;
            return true;
        }
        if (reference instanceof GroupRef) {
            Group o_casted = (Group)o;
            o_casted.linkProject(this);
            this.group = o_casted;
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkProject(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public Group getLinkedGroup() {
        return this.group;
    }

    public void linkGroup(Group o) {
        this.group = o;
    }

    public void unlinkGroup(Group o) {
        if (this.group == o) {
            this.group = null;
        }
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkProject(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkProject(this);
        return this.annotationList.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.dataset_BackReferenceList.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.dataset_BackReferenceList);
    }

    public Dataset getLinkedDataset(int index) {
        return this.dataset_BackReferenceList.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.dataset_BackReferenceList.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.dataset_BackReferenceList.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.dataset_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Project_element) {
        Reference o;
        if (Project_element == null) {
            Project_element = document.createElementNS(NAMESPACE, "Project");
        }
        if (this.name != null) {
            Project_element.setAttribute("Name", this.name.toString());
        }
        if (this.id != null) {
            Project_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Project_element.appendChild(description_element);
        }
        if (this.experimenter != null) {
            o = new ExperimenterRef();
            ((ExperimenterRef)o).setID(this.experimenter.getID());
            Project_element.appendChild(((ExperimenterRef)o).asXMLElement(document));
        }
        if (this.group != null) {
            o = new GroupRef();
            ((GroupRef)o).setID(this.group.getID());
            Project_element.appendChild(((GroupRef)o).asXMLElement(document));
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                AnnotationRef o2 = new AnnotationRef();
                o2.setID(annotationList_value.getID());
                Project_element.appendChild(o2.asXMLElement(document));
            }
        }
        if (this.dataset_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Project_element);
    }
}

