/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncMapping;
import com.jcraft.jorbis.Info;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Block {
    float[][] pcm;
    Buffer opb;
    int lW;
    int W;
    int nW;
    int pcmend;
    int mode;
    int eofflag;
    long granulepos;
    long sequence;
    DspState vd;
    int glue_bits;
    int time_bits;
    int floor_bits;
    int res_bits;

    public void init(DspState vd) {
        this.vd = vd;
    }

    public int clear() {
        if (this.vd != null && this.vd.analysisp != 0) {
            this.opb.writeclear();
        }
        return 0;
    }

    public int synthesis(Packet op) {
        Info vi = this.vd.vi;
        this.opb.readinit(op.packet_base, op.packet, op.bytes);
        if (this.opb.read(1) != 0) {
            return -1;
        }
        int _mode = this.opb.read(this.vd.modebits);
        if (_mode == -1) {
            return -1;
        }
        this.mode = _mode;
        this.W = vi.mode_param[this.mode].blockflag;
        if (this.W != 0) {
            this.lW = this.opb.read(1);
            this.nW = this.opb.read(1);
            if (this.nW == -1) {
                return -1;
            }
        } else {
            this.lW = 0;
            this.nW = 0;
        }
        this.granulepos = op.granulepos;
        this.sequence = op.packetno - (long)3;
        this.eofflag = op.e_o_s;
        this.pcmend = vi.blocksizes[this.W];
        if (this.pcm.length < vi.channels) {
            this.pcm = new float[vi.channels][];
        }
        int i = 0;
        while (i < vi.channels) {
            if (this.pcm[i] == null || this.pcm[i].length < this.pcmend) {
                this.pcm[i] = new float[this.pcmend];
            } else {
                int j = 0;
                while (j < this.pcmend) {
                    this.pcm[i][j] = 0.0f;
                    ++j;
                }
            }
            ++i;
        }
        int type = vi.map_type[vi.mode_param[this.mode].mapping];
        return FuncMapping.mapping_P[type].inverse(this, this.vd.mode[this.mode]);
    }

    private final /* synthetic */ void this() {
        this.pcm = new float[0][];
        this.opb = new Buffer();
    }

    public Block(DspState vd) {
        this.this();
        this.vd = vd;
        if (vd.analysisp != 0) {
            this.opb.writeinit();
        }
    }
}

