/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Caps;
import java.util.EmptyStackException;
import java.util.Stack;

public class Buffer {
    private static Stack pool = new Stack();
    private static int live;
    public static final int FLAG_DISCONT = 1;
    public static final int FLAG_DELTA_UNIT = 2;
    public int flags;
    public Object object;
    public byte[] data;
    public int offset;
    public int length;
    public Caps caps;
    public long time_offset;
    public long timestamp;
    public long timestampEnd;

    public static Buffer create() {
        Buffer result;
        try {
            result = (Buffer)pool.pop();
        }
        catch (EmptyStackException e) {
            result = new Buffer();
            ++live;
        }
        result.time_offset = -1;
        result.timestamp = -1;
        result.timestampEnd = -1;
        result.flags = 0;
        return result;
    }

    public boolean isFlagSet(int flag) {
        boolean bl = false;
        if ((this.flags & flag) == flag) {
            bl = true;
        }
        return bl;
    }

    public void setFlag(int flag, boolean val) {
        this.flags = val ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void free() {
        this.object = null;
        this.caps = null;
        pool.push(this);
    }

    public void ensureSize(int length) {
        if (this.data == null) {
            this.data = new byte[length];
        } else if (this.data.length < length) {
            this.data = new byte[length];
        }
    }

    public void copyData(byte[] data, int offset, int length) {
        this.ensureSize(length);
        System.arraycopy(data, offset, this.data, 0, length);
        this.offset = 0;
        this.length = length;
    }
}

